<?php 
/**
 * @package SEOfant
 */

/**
 * Plugin Name: SEOfant
 * Plugin URI: https://www.seofant.com/downloads.php
 * Description: Text- und Grammatik-Hilfe für die deutsche Sprache (D-A-CH)
 * Version: 1.2.7
 * Author: Team SEOfant
 * Author URI: https://www.seofant.com
 * Text Domain: seofant
 * License: GPL v3
 */

/**
 * SEOfant Wordpress Plugin
 * Copyright (C) 2013 - 2020, SEOfant - support@seofant.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

defined('ABSPATH') or die('Script kiddies are not welcome!');

class SEOfant_wpPlugin {
	const	VERSION 		= '1.2.7';
	private $location 		= 'http://wp.seofant.com/soap_server.php'; // 'http://localhost:12001/soap_server.php';
	
	private $soapEnabled 	= 0;
	private $cssNamensraum 	= 'SEOfantCSS';
	
	function __construct () {
		if (extension_loaded('soap')) {
			$this->soapEnabled = 1;
		}
		
		add_action('add_meta_boxes',  array($this, 'seofant_add_custom_meta_box'));
	}
	
	final public function seofant_customCSS () {
		$src = plugins_url('css/seofant.min.css', __FILE__);
		
		wp_register_script($this->cssNamensraum, $src);
		wp_enqueue_style($this->cssNamensraum, $src, array(), false, false);
	}
	
	final public function seofant_add_custom_meta_box () {
		add_meta_box(
			'seofant_metabox_in_backend',
			'SEOfant',
			array($this, 'seofant_add_content_to_meta_box')
		);
	}
	
	final public function seofant_add_content_to_meta_box () {
		if ($this->soapEnabled === 1) {
			$output = "<p class=\"seofant\" data-sec=\"" . wp_create_nonce("analyze") . "\" data-url=\"" . 
				plugins_url('seofant/img/seofant_working.gif', dirname(__FILE__)) . 
			"\">" . 
				"<a href=\"javascript:seofant.analyzeView()\">Seite analysieren</a>" . 
			"</p>" . 
			
			"<p class=\"seofant_ergebnis\"></p>";
			
		} else {
			$output = '<p>Leider kannst Du den SEOfant nicht nutzen, da Dein System keine SOAP-Schnittstelle aktiviert hat.</p>';
		}
		
		echo $output;
	}
	
	final public function seofant_sanitizeBodyFromWPstuff ($content) {
		$doc = new DOMDocument();
		$doc->preserveWhiteSpace = false;
		$doc->loadHTML('<?xml encoding="utf-8" ?>' . $content);
		
		$adminbar = $doc->getElementById('wpadminbar');
		if ($adminbar != NULL) {
			$adminbar->parentNode->removeChild($adminbar);
		}
		
		$amendedHtml = $doc->saveHTML(); 
		
		return $amendedHtml;
	}
	
	final public function seofant_grabCookies () {
		$cookies = array();

		foreach ($_COOKIE as $name => $value) {
			$cookies[] = new WP_Http_Cookie(
				array('name' => $name, 'value' => $value)
			);
		}
		
		return $cookies;
	}
	
	final private function seofant_requestResult ($permalink, $textZurAnalyse) {
		$output = '';
		
		$options = array(
			'location'      => $this->location,
			'uri'           => 'http://wpfant',
			'soap_version'	=> SOAP_1_2,
			// 'compression' 	=> (SOAP_COMPRESSION_ACCEPT | SOAP_COMPRESSION_GZIP | 9)
			// ,'cache_wsdl' 	=> (defined(WSDL_CACHE_NONE) ? WSDL_CACHE_NONE : 0)
		);
		
		if (extension_loaded('soap')) {
			try {
				$client = new SoapClient(null, $options);
				
				$params = array(
					'ip' 		=> strval($_SERVER['SERVER_ADDR']),
					'domain'	=> $permalink,
					'api'		=> '',
					'txt'		=> $textZurAnalyse,
					'me'		=> (isset($_SERVER['REMOTE_ADDR']) ? strval($_SERVER['REMOTE_ADDR']) : getenv('REMOTE_ADDR')),
					'version'	=> self::VERSION
				);
				
				$output = $client->analyzeTxt($params);
				
				unset($client);
				
			} catch (SoapFault $ex) {
				$output = 'FEHLER (' . __LINE__ . ') :: Unerwartet, aber kommt leider vor. Wir sind informiert und kümmern uns bestimmt schon darum.<br>' . 
					'<em>[' . $ex . ']</em>';
				
			}
		} else {
			$output = 'FEHLER (' . __LINE__ . ') :: SOAP nicht verfügbar.';
		}
		
		return $output;
	}
	
	final public function seofant_analyze () {
		$output = '';
		
		$url = sanitize_text_field(trim($_POST['a']));
		if (mb_strlen($url, 'utf-8') > 0) {
			check_admin_referer('analyze', 'b');
			
			$cookies = $this->seofant_grabCookies();
			
			$request = wp_remote_get(
				set_url_scheme( $url ),
				array('cookies' => $cookies)
			);
			
			$_body 	= wp_remote_retrieve_body( $request );
			$body 	= $this->seofant_sanitizeBodyFromWPstuff($_body);
			
			$output = $this->seofant_requestResult($url, $body);
			
		} else {
			$output = '<p>Sorry, an dieser Stelle kann der SEOfant nicht ausgeführt werden.</p>';
		}
		
		echo $output;
		
		wp_die();
	}
	
	final public function seofant_settings () {
		$output = '';
		
		check_admin_referer('analyze', 'b');
		
		$url = sanitize_text_field($_POST['a']);
		$api = sanitize_text_field($_POST['c']);
		
		$options = array(
			'location'      => 'http://wp.seofant.com/soap_server_apikey.php',
			'uri'           => 'http://apifant',
			'soap_version'	=> SOAP_1_2,
			'compression' 	=> (SOAP_COMPRESSION_ACCEPT | SOAP_COMPRESSION_GZIP | 9)
		);
		
		if (extension_loaded('soap')) {
			try {
				$client = new SoapClient(null, $options);
				
				$params = array(
					'ip' 		=> $_SERVER['SERVER_ADDR'],
					'domain'	=> $url,
					'api'		=> $api,
					'me'		=> (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : getenv('REMOTE_ADDR')),
					'version'	=> self::VERSION
				);
				
				$output = $client->checkApiKey( $params );
				
				unset($client);
				
			} catch (SoapFault $ex) {
				$output = 'FEHLER (' . __LINE__ . ') :: API Schlüssel konnte nicht überprüft werden.';
			}
		} else {
			$output = 'FEHLER (' . __LINE__ . ') :: SOAP nicht verfügbar.';
		}
		
		echo $output;
		
		wp_die();
	}
	
	/*
	final private function soapDebug ($client) {
		$requestHeaders 	= $client->__getLastRequestHeaders();
		$request 			= prettyXml($client->__getLastRequest());
		$responseHeaders 	= $client->__getLastResponseHeaders();
		$response 			= prettyXml($client->__getLastResponse());
		
		echo '<code>' . nl2br(htmlspecialchars($requestHeaders, true)) . '</code>';
		echo highlight_string($request, true) . '<br>' . "\n";

		echo '<code>' . nl2br(htmlspecialchars($responseHeaders, true)) . '</code><br>' . "\n";
		echo highlight_string($response, true) . '<br>' . "\n";
		
		wp_die();
	}
	*/
}

if (is_admin()) {
	$fantGehege = new SEOfant_wpPlugin;
	
	add_action('admin_head', array($fantGehege, 'seofant_customCSS'));
	
	wp_enqueue_script(
		'seofant',
		plugins_url('js/seofant.js', __FILE__ ),
		array(),
		false,
		true
	);
	
	add_action('wp_ajax_SEOFANTanalyze', 	array($fantGehege, 'seofant_analyze'));
	add_action('wp_ajax_SEOFANTsettings',	array($fantGehege, 'seofant_settings'));
	
	unset($fantGehege);
}
