let seofant = {
	$fant: 	jQuery('.seofant'),
	found: 	0,
	run: 	0,
	sec: 	"",
	waitS: 	"",
	leer: 	"",
	gt: 	{},
	plot:	"",
	wpv: 	4,
	gmetaU: "",
	
	init: function(){
		seofant.found = parseInt(seofant.$fant.length, 10);
		seofant.leer = seofantig.defaults.s0;
		
		if(seofant.found == 1){
			seofant.waitS = "<img src=\"" + seofant.$fant.attr('data-url').trim() + "\" alt=\"\">";
			seofant.clickHandler();
		}
	},
	
	clickHandler: function(){
		let $l = jQuery('#seofant_metabox_in_backend a:not([target])'),
			l = "";
			
		$l.unbind('click');
		$l.on('click', function(e){
			l = jQuery(this).attr('href');
			if(l.indexOf('analyze') !== -1) 	seofant.analyzeView(jQuery(this), e);
			if(l.indexOf('settings') !== -1) 	seofant.settings(jQuery(this), e);
			if(l.indexOf('store') !== -1) 		seofant.store(jQuery(this), e);
		});
		seofant.sec = seofant.$fant.data('sec');
	},
	
	pickPermaLink: function(){
		let wp4		= jQuery('#sample-permalink'),
			wp5		= jQuery('.editor-post-preview'),
			$obj 	= (wp4.length > 0 ? wp4 : wp5),
			url		= "",
			attr	= $obj.attr('href');
		
		seofant.wpv 	= (wp4.length > 0 ? 4 : 5);
		seofant.gmetaU 	= attr;
		
		if(typeof attr !== typeof undefined && attr !== false){
			url = $obj.attr('href').trim();
		} else if($obj.find('a').length == 1){
			url = $obj.find('a').attr('href').trim();
		}
		
		return url;
	},
	
	handleSoapValues: function(a, b, $lnk, $res){
		try {
			let json = JSON.parse(b),
				seofantSpricht = '';
			
			if(typeof json.error !== typeof undefined && json.error !== false){
				if (json.error > 0) {
					seofantSpricht += '<p class="seofant_error">' + json.txt + '</p>';
				} else {
					seofantSpricht += seofantig.meta(json.meta);
					seofantSpricht += seofantig.robots(json.robots);
					seofantSpricht += seofantig.headlines(json.headlines);
					seofantSpricht += seofantig.grammatik(json.grammatik);
					seofantSpricht += seofantig.genderism(json.genderism);
					seofantSpricht += seofantig.c2c(json.c2c);
					seofantSpricht += seofantig.fre(json.fre);
					seofantSpricht += seofantig.semantic(json.docOutline);
					seofantSpricht += seofantig.opengraph(json.opengraph);
					seofantSpricht += seofantig.twitter(json.twitter['meta']);
					seofantSpricht += seofantig.snippets(json.snippets);
				}
				
				$res.html(seofantSpricht);
				
				jQuery('.clk').unbind('click');
				jQuery('.clk').on('click', function(){
					jQuery(this).parent().toggleClass('closed');
					jQuery(this).next().toggleClass('ninja');
					
					if(!jQuery(this).next().hasClass('ninja') && jQuery(this).next().find('#gmetaT').length == 1){
						jQuery('body').find('#inPx1').html(parseInt(jQuery('#gmetaT > em').css("width"), 10) + " px");
						jQuery('body').find('#inPx2').html(parseInt(jQuery('#gmetaD > em').css("width"), 10) + " px");
					}
				});
				
			} else {
				$res.html(seofantig.err.e3);
			}
			
		} catch(err) {
			$res.html(b);
		}
		
		$lnk.html(a);
		seofant.clickHandler();
		seofant.run = 0;
	},
	
	analyzeView: function($o, e){
		e.preventDefault();
		
		let data		= {},
			temp		= '',
			$obj		= jQuery('#seofant_metabox_in_backend .inside'),
			$lnk		= $obj.find('.seofant'),
			$res		= $obj.find('.seofant_ergebnis'),
			pl 			= seofant.pickPermaLink();
		
		$res.attr('style', "display:none").html(seofant.leer).removeAttr('style');
		
		if(seofant.run == 0){
			seofant.run = 1;
			
			temp = $lnk.html();
			$lnk.html(seofant.waitS);
			
			data = {
				'action': 'SEOFANTanalyze',
				'a': pl,
				'b': seofant.sec,
				'c': seofant.wpv
			};
			
			jQuery.post(ajaxurl, data, function(c) {
				seofant.handleSoapValues(temp, c, $lnk, $res);
			});
		}
	},
	
	settings: function($obj, e){
		e.preventDefault();
		
		let $res = jQuery('.seofant_ergebnis');
		$res.find('a').unbind('click');
		seofant.plot = $res.html();
		
		$res.fadeOut('fast', function(){
			seofantsets.showSettings($res);
		});
	},
	
	store: function($obj, e){
		e.preventDefault();
		seofantsets.setSettings();
	}
},

seofantig = {
	output: '',
	
	haveFound: '<span class="green">gefunden</span>',
	notFound: '<span class="red">nicht gefunden</span>',
	isAllowed: '<span class="green">erlaubt</span>',
	notAllowed: '<span class="red">nicht erlaubt</span>',
	unknown: '<p class="red">Der Bereich konnte nicht ermittelt werden.</p>',
	
	err: {
		e0: '<p><span>Nicht gefunden</span>',
		e1: '... und das sollte zügig behoben werden!</p>',
		e2: '... und ist für die SERPS nicht notwendig.</p>',
		e3: 'Irgendwas ging irgendwo irgendwie nicht gut ... ',
		e4: 'Offenbar hat der SEOfant Probleme im Gehege – wir prüfen das!'
	},
	
	defaults: {
		s0: '<i>Dann schauen wir mal, wie diese Seite abschneidet ... Geduld, bitte!</i>',
		s1:	'Information ein/ausblenden:'
	},
	
	init: function(){
		seofantig.output = '';
	},
	
	appendButton: function(str){
		/*
		return '<button type="button" class="handlediv" aria-expanded="false"><span class="screen-reader-text">' + 
			seofantig.defaults.s1 + ' ' + str + 
		'</span><span class="toggle-indicator" aria-hidden="true"></span></button>';
		*/
		
		return '';
	},
	
	headlines: function($j){
		seofantig.init();
		
		seofantig.output += "<div class=\"postboxSF closed\">";
		seofantig.output += seofantig.appendButton("Überschriften");
		seofantig.output += "<h2 class=\"clk\">Überschriften</h2>";
		seofantig.output += "<div class=\"ninja\">";
		
		seofantig.output += seofantissimo.helpContent.h2;
		
		seofantig.output += "<h3>Primäre Überschrift</h3>";
		seofantig.output += seofantissimo.helpContent.h3;
		
		try {
			seofantig.output += "<p><span>Erste Überschrift der Seite</span>" + $j.firstHL + "</p>";
			seofantig.output += "<p><span>Rangordnung dieser Überschrift</span>H" + $j.firstHLRank + "</p>";
			seofantig.output += "<p><span>Ausreichend Wörter für eine erste Überschrift?</span>" + $j.firstEnoughWords + "</p>";
			seofantig.output += "<p><span>Zu viele Zeichen für eine erste Überschrift?</span>" + $j.firstTooManyChars + "</p>";
			
			seofantig.output += "<h3>Vorgefundene Überschriften</h3>";
			seofantig.output += seofantissimo.helpContent.h4;
			seofantig.output += "<p>";
				for(let i = 1; i <= 6; i++){
					if(i > 1) seofantig.output += "<br>";
					seofantig.output += "<span>Anzahl H" + i + ": " + $j.usedHLtype[i] + "</span>";
					if(typeof $j.usedAsHL[i] !== typeof undefined && $j.usedAsHL[i] !== false){
						jQuery.each($j.usedAsHL[i], function(k, v){
							seofantig.output += "... " + v + "<br>";
						});
					}
				}
			seofantig.output += "</p>";
			
			seofantig.output += "<h3>Chronologie der Überschriften</h3>";
			seofantig.output += seofantissimo.helpContent.h5;
			seofantig.output += "<p>";
				jQuery.each($j.usedHLsort, function(k, v){
					seofantig.output += "... " + v[0] + " (H" + v[1] + ")<br>";
				});
			seofantig.output += "</p>";
			
		} catch (err) {
			seofantig.output += seofantig.unknown;
		}
		
		seofantig.output += "</div>";
		seofantig.output += "</div>";
		
		return seofantig.output;
	},
	
	grammatik: function($j){
		seofantig.init();
		
		seofantig.output += "<div class=\"postboxSF closed\">";
		seofantig.output += seofantig.appendButton("Wörter und Sätze");
		seofantig.output += "<h2 class=\"clk\">Wörter &amp; Sätze</h2>";
		seofantig.output += "<div class=\"ninja\">";
		seofantig.output += seofantissimo.helpContent.h6;
		
		try {
			seofantig.output += "<p><span>Anzahl verwertbarer Wörter der <b>gesamten</b> Seite</span>" + $j.anzahl + "</p>";
			seofantig.output += "<p><span>Bewertung des Textumfangs</span>" + $j.textvolumen + "</p>";
			
			seofantig.output += $j.grammar + "<br>";
			
			seofantig.output += "<h3>Meistgenutzte Wörter</h3>";
			seofantig.output += seofantissimo.helpContent.h7;
			seofantig.output += $j.words;
			
		} catch (err) {
			seofantig.output += seofantig.unknown;
		}
		
		seofantig.output += "</div>";
		seofantig.output += "</div>";
		
		return seofantig.output;
	},
	
	meta: function($j){
		seofantig.init();
		
		seofantig.output += "<div class=\"postboxSF fst closed\">";
		seofantig.output += seofantig.appendButton("Rudimentäre Basis");
		seofantig.output += "<h2 class=\"clk\">Rudimentäre Basis</h2>";
		seofantig.output += "<div class=\"ninja\">";
		
		try {
			seofantig.output += "<h3>Google SERP (fiktiv)</h3>";
			seofantig.output += "<p>";
			if($j.seitentitel.report == "") seofantig.output += '<div id="gmetaT"><em>' + $j.seitentitel.txt + '</em></div>';
			seofantig.output += '<div id="gmetaU">' + seofant.gmetaU + '</div>';
			if($j.description.found == 1) 	seofantig.output += '<div id="gmetaD"><em>' + $j.description.inUse + '</em></div>';
			seofantig.output += "</p>";
			seofantig.output += "<hr>";
			
			seofantig.output += seofantissimo.helpContent.h1;
			
			seofantig.output += "<h3>Seitentitel</h3>";
			if($j.seitentitel.report == ""){
				seofantig.output += "<p><span>vorgefunden</span>" + $j.seitentitel.txt + "</p>";
				seofantig.output += "<p><span>Relevanz zum Content</span>" + $j.seitentitel.relevanz + "</p>";
				seofantig.output += "<p><span>Anzahl Zeichen</span>" + $j.seitentitel.zeichen + "</p>";
				seofantig.output += "<p><span>Länge in px (max. 512 px)</span><em id=\"inPx1\">0</em></p>";
				
			} else {
				seofantig.output += seofantig.err.e0 + seofantig.err.e1;
			}
				
			seofantig.output += "<h3>Description</h3>";
			if($j.description.found == 1){
				seofantig.output += "<p><span>vorgefunden</span>" + $j.description.inUse + "</p>";
				seofantig.output += "<p><span>Relevanz zum Content</span>" + $j.description.relevanz + "</p>";
				seofantig.output += "<p><span>Anzahl Zeichen (Wörter)</span>" + $j.description.zeichen + " (" + $j.description.words + ")</p>";
				seofantig.output += "<p><span>Länge in px (max. 512 px)</span><em id=\"inPx2\">0</em></p>";
				
			} else {
				seofantig.output += seofantig.err.e0 + seofantig.err.e1;
			}
			
			if($j.keywords.found == 1){
				seofantig.output += "<h3>Keywords*</h3>";
				seofantig.output += "<p><span>vorgefunden</span>" + $j.keywords.inUse + "</p>";
				seofantig.output += "<p><span>Anzahl Zeichen (Wörter)</span>" + $j.keywords.zeichen + " (" + $j.keywords.words + ")</p>";
				seofantig.output += "<p><span>Relevanz zum Content</span>" + $j.keywords.relevanz + "</p>";
				
				seofantig.output += "<p><span>* Zugegeben, sie werden für die SERPS nicht mehr beachtet. Falls dennoch als Verschlagwortung gesetzt, haben diese zwingend zu passen!</span></p>";
				
			} else {
				seofantig.output += "<h3>Keywords</h3>";
				seofantig.output += seofantig.err.e0 + seofantig.err.e2;
			}
		} catch (err) {
			seofantig.output += seofantig.unknown;
		}
		
		seofantig.output += "</div>";
		seofantig.output += "</div>";
		
		return seofantig.output;
	},

	c2c: function($j){
		seofantig.init();
		
		seofantig.output += "<div class=\"postboxSF closed\">";
		seofantig.output += seofantig.appendButton("Text-to-Code");
		seofantig.output += "<h2 class=\"clk\">Text-to-Code</h2>";
		seofantig.output += "<div class=\"ninja\">";
		seofantig.output += seofantissimo.helpContent.h8;
		
		try {
			seofantig.output += "<p><span>Relation</span>" + $j.c2c + " %</p>";
			seofantig.output += "<p><span>Bewertung</span>" + $j.rated + "</p>";
		} catch (err) {
			seofantig.output += seofantig.unknown;
		}
		
		seofantig.output += "</div>";
		seofantig.output += "</div>";
		
		return seofantig.output;
	},
	
	fre: function($j){
		seofantig.init();
		
		seofantig.output += "<div class=\"postboxSF closed\">";
		seofantig.output += seofantig.appendButton("Lesbarkeitsindex");
		seofantig.output += "<h2 class=\"clk\">Lesbarkeitsindex</h2>";
		seofantig.output += "<div class=\"ninja\">";
		
		try {
			seofantig.output += seofantissimo.helpContent.h9;
			seofantig.output += "<p><span>Anzahl Sätze</span>" + $j.anzahlSaetze + "</p>";
			seofantig.output += "<p><span>Ø Wörter je Satz</span>" + $j.schnittAnzahlWoerterJeSatz + "</p>";
			
			seofantig.output += "<p><span>Flesch-Reading-Ease</span>" + $j.fre_de + "</p>";
			seofantig.output += $j._explain;
			
			seofantig.output += seofantissimo.helpContent.h10;
			seofantig.output += "<p><span>Wiener-Sachtext-Formel 1</span>" + $j.wstf1 + "</p>";
			seofantig.output += "<p><span>Wiener-Sachtext-Formel 2</span>" + $j.wstf2 + "</p>";
			seofantig.output += "<p><span>Wiener-Sachtext-Formel 3</span>" + $j.wstf3 + "</p>";
			seofantig.output += "<p><span>Wiener-Sachtext-Formel 4</span>" + $j.wstf4 + "</p>";

			seofantig.output += seofantissimo.helpContent.h17;
			seofantig.output += "<p><span>LIX</span>" + $j.lix + "</p>";
			seofantig.output += $j.lixinfo;
			
		} catch (err) {
			seofantig.output += seofantig.unknown;
		}
		
		seofantig.output += "</div>";
		seofantig.output += "</div>";
		
		return seofantig.output;
	},
	
	semantic: function(string){
		seofantig.init();
		
		seofantig.output += "<div class=\"postboxSF closed\">";
		seofantig.output += seofantig.appendButton("Semantik der Seite (DOM)");
		seofantig.output += "<h2 class=\"clk\">Semantik der Seite (DOM)</h2>";
		seofantig.output += "<div class=\"ninja\">";
		seofantig.output += seofantissimo.helpContent.h11;
		
		try {
			seofantig.output += "<p>" + string + "</p>";
		} catch (err) {
			seofantig.output += seofantig.unknown;
		}
		
		seofantig.output += "</div>";
		seofantig.output += "</div>";
		
		return seofantig.output;
	},
	
	snippets: function(string){
		seofantig.init();
		
		seofantig.output += "<div class=\"postboxSF closed\">";
		seofantig.output += seofantig.appendButton("Rich Snippets");
		seofantig.output += "<h2 class=\"clk\">Rich Snippets</h2>";
		seofantig.output += "<div class=\"ninja\">";
		seofantig.output += seofantissimo.helpContent.h12;
		
		try {
			seofantig.output += string;
		} catch (err) {
			seofantig.output += seofantig.unknown;
		}
		
		seofantig.output += "</div>";
		seofantig.output += "</div>";
		
		return seofantig.output;
	},
	
	genderism: function(string){
		seofantig.init();
		
		seofantig.output += "<div class=\"postboxSF closed\">";
		seofantig.output += seofantig.appendButton("Neutrale Formulierung");
		seofantig.output += "<h2 class=\"clk\">Neutrale Formulierung</h2>";
		seofantig.output += "<div class=\"ninja\">";
		seofantig.output += seofantissimo.helpContent.h13;
		
		try {
			seofantig.output += string;
		} catch (err) {
			seofantig.output += seofantig.unknown;
		}
		
		seofantig.output += "</div>";
		seofantig.output += "</div>";
		
		return seofantig.output;
	},
	
	opengraph: function($j){
		seofantig.init();
		
		seofantig.output += "<div class=\"postboxSF closed\">";
		seofantig.output += seofantig.appendButton("Open Graph (bspw. Facebook, XING)");
		seofantig.output += "<h2 class=\"clk\">Open Graph</h2>";
		seofantig.output += "<div class=\"ninja\">";
		seofantig.output += seofantissimo.helpContent.h14;
		
		try {
			seofantig.output += '<p><b>og:title</b><br>' + ($j['og:title'][0] === true ? seofantig.haveFound : seofantig.notFound) + '</p>';
			if ($j['og:title'][0] === false) seofantig.output += $j['og:title'][1] + '<br>';
			
			seofantig.output += '<p><b>og:description</b><br>' + ($j['og:description'][0] === true ? seofantig.haveFound : seofantig.notFound) + '</p>';
			if ($j['og:description'][0] === false) seofantig.output += $j['og:description'][1] + '<br>';
			
			seofantig.output += '<p><b>og:image</b><br>' + ($j['og:image'][0] === true ? seofantig.haveFound : seofantig.notFound) + '</p>';
			if ($j['og:image'][0] === false) seofantig.output += $j['og:image'][1] + '<br>';
			
			seofantig.output += '<p><b>og:site_name</b><br>' + ($j['og:site_name'][0] === true ? seofantig.haveFound : seofantig.notFound) + '</p>';
			if ($j['og:site_name'][0] === false) seofantig.output += $j['og:site_name'][1] + '<br>';
			
			seofantig.output += '<p><b>og:url</b><br>' + ($j['og:url'][0] === true ? seofantig.haveFound : seofantig.notFound) + '</p>';
			if ($j['og:url'][0] === false) seofantig.output += $j['og:url'][1] + '<br>';
			
			seofantig.output += '<p><b>og:type</b><br>' + ($j['og:type'][0] === true ? seofantig.haveFound : seofantig.notFound) + '</p>';
			if ($j['og:type'][0] === false) seofantig.output += $j['og:type'][1] + '<br>';
			
			seofantig.output += '<p><b>og:locale</b><br>' + ($j['og:locale'][0] === true ? seofantig.haveFound : seofantig.notFound) + '</p>';
			if ($j['og:locale'][0] === false) seofantig.output += $j['og:locale'][1];
		} catch (err) {
			seofantig.output += seofantig.unknown;
		}
		
		seofantig.output += "</div>";
		seofantig.output += "</div>";
		
		return seofantig.output;
	},
	
	twitter: function($j){
		seofantig.init();
		
		seofantig.output += "<div class=\"postboxSF closed\">";
		seofantig.output += seofantig.appendButton("Twitter");
		seofantig.output += "<h2 class=\"clk\">Twitter</h2>";
		seofantig.output += "<div class=\"ninja\">";
		seofantig.output += seofantissimo.helpContent.h15;
		
		try {
			seofantig.output += '<p><b>twitter:card</b><br>' + ($j['card'].indexOf('class="hlpExpl"') === -1 ? seofantig.haveFound : seofantig.notFound) + '</p>' + $j['card'];
			seofantig.output += '<p><b>twitter:title</b><br>' + ($j['title'].indexOf('class="hlpExpl"') === -1 ? seofantig.haveFound : seofantig.notFound) + '</p>' + $j['title'];
			seofantig.output += '<p><b>twitter:description</b><br>' + ($j['description'].indexOf('class="hlpExpl"') === -1 ? seofantig.haveFound : seofantig.notFound) + '</p>' + $j['description'];
			seofantig.output += '<p><b>twitter:image</b><br>' + ($j['image'].indexOf('class="hlpExpl"') === -1 ? seofantig.haveFound : seofantig.notFound) + '</p>' + $j['image'];
			seofantig.output += '<p><b>twitter:url</b><br>' + ($j['url'].indexOf('class="hlpExpl"') === -1 ? seofantig.haveFound : seofantig.notFound) + '</p>' + $j['url'];
			seofantig.output += '<p><b>twitter:site</b><br>' + ($j['site'].indexOf('class="hlpExpl"') === -1 ? seofantig.haveFound : seofantig.notFound) + '</p>' + $j['site'];
			seofantig.output += '<p><b>twitter:creator</b><br>' + ($j['creator'].indexOf('class="hlpExpl"') === -1 ? seofantig.haveFound : seofantig.notFound) + '</p>' + $j['creator'];
		} catch (err) {
			seofantig.output += seofantig.unknown;
		}
		
		seofantig.output += "</div>";
		seofantig.output += "</div>";
		
		return seofantig.output;
	},
	
	robots: function($j) {
		seofantig.init();
		
		seofantig.output += "<div class=\"postboxSF closed\">";
		seofantig.output += seofantig.appendButton("Robots");
		seofantig.output += "<h2 class=\"clk\">Robots</h2>";
		seofantig.output += "<div class=\"ninja\">";
		seofantig.output += seofantissimo.helpContent.h16;
		
		try {
			switch ($j['found']) {
				case 0:
					seofantig.output += '<p class="hlpExpl">Wenn kein Robots-Meta angegeben ist, ist der Standard <em>index,follow</em> bzw. <em>all</em></p>';
				break;
				
				case 1:
					seofantig.output += '<p><b>Indexierung:</b><br>' + ($j['allowed'] == 'ja' ? seofantig.isAllowed : seofantig.notAllowed) + '</p>';
					seofantig.output += '<p><b>aktuelle Anweisung:</b><br>' + $j['used'] + '</p>';
					seofantig.output += '<p><b>Hinweis:</b><br>' + $j['tip'] + '</p>';
				break;
				
				default:
					seofantig.output += '<p class="red">Es sind mehrere robots-Anweisungen über mehrere Zeilen gefunden worden. Korrigiere dies auf einen Eintrag!</p>';
				break;
			}
		} catch (err) {
			seofantig.output += seofantig.unknown;
		}
		
		seofantig.output += "</div>";
		seofantig.output += "</div>";
		
		return seofantig.output;
	}
},

seofantissimo = {
	helpContent: {
		h1: "<p class=\"hlp\">Das Title-Tag sowie die Meta-Description sind die ersten Berührungspunkte Deiner Webseite mit einem Suchenden. Sie sind daher maßgeblich für die Klickrate (kurz: CTR) verantwortlich. Bemühe Dich, den Suchenden zum Klick zu animieren – durch &bdquo;Attention, Interest, Desire &amp; Action&rdquo;. In der Folgenutzung hat der User das Title-Tag bspw. als Reiter-Bezeichner sowie als Text in einem bei sich gesetzten Bookmark. Oder anders formuliert: Würdest Du Dich von Deinem SERP – wie oben dargestellt – angesprochen fühlen und diesen (wenn auch nur 1&times;) anklicken?</p>",
		
		h2: "<p class=\"hlp\">Die Übersicht soll helfen den Überblick über eine Seite zu wahren. Der Fokus liegt hier - ungeachtet einer Semantik - auf den typischen Headline-Tags (H1 - H6).</p>",
		
		h3: "<p class=\"hlp\">Als &bdquo;primär&rdquo; bezeichnen wir die Überschrift, die – ähnlich eines Inhaltsverzeichnisses in einem Buch – tatsächlich als erstes im Quellcode als solche wahrgenommen wird. Die Empfehlung lautet, ein H1 zu veranschlagen und in der Folge mit einer korrekten Semantik sowie H2 und höher (bspw. in einem article-Tag) zu arbeiten. Und ja, man darf auf einer Seite mehrere H1-Tags verwenden, sofern der Quellcode die erforderliche Struktur hat.</p>",
		
		h4: "<p class=\"hlp\">An dieser Stelle haben wir uns erlaubt, alle Überschriften aufzulisten, die in der Seite genutzt werden.</p>",
		
		h5: "<p class=\"hlp\">Die Überschriften treten in der gezeigten Reihenfolge im Quellcode auf. Der Bezeichner in Klammern gibt an, um welche Rangordnung es sich handelt.</p>",
		
		h6: "<p class=\"hlp\">Regel Nr. 1: &bdquo;Content is king!&rdquo; Seiten, die einen qualitativen Mehrwert für die Nutzungserfahrung eines Users von Google haben wollen, sollten mindestens über 900&nbsp;Wörter <b>sinnvollen</b> Text verfügen.</p><p class=\"hlp\">Schreibe Deine Texte für Besucher – nicht für Suchmaschinen! Ist ein Text ausformuliert, ergibt sich zwangsläufig ein natürliches sowie ein signifikantes Vorkommen von Wörtern (quasi das &bdquo;keyword&rdquo; der Seite). Was ist also das meistgenutzte Wort dieser Seite?</p>",
		
		h7: "<p class=\"hlp\">&bdquo;Natürliches Vorkommen&rdquo; benennt die Anzahl der Wörter in exakt gleicher Schreibweise. &bdquo;Signifikantes Vorkommen&rdquo; meint jedes Wort in einer Kleinschreibweise und nennt diese Häufigkeit.</p>",
		
		h8: "<p class=\"hlp\">Optisch starke Seite, aber kaum Text? Das rächt sich immer. Unser &bdquo;Code-2-Content&rdquo;-Hinweis gibt Aufschluss darüber, ob eine Seite mehr Quellcode für eine Darstellung hat oder eben für einen Benutzer wertvollen, lesbaren Inhalt liefert.</p>",
		
		h9: "<p class=\"hlp\">Der Lesbarkeitsindex <a href=\"https://de.wikipedia.org/wiki/Lesbarkeitsindex\" title=\"Wikipedia: Flesch-Reading-Ease\" target=\"_blank\">Flesch-Reading-Ease</a> (FRE), auch Flesch-Grad genannt, ist ein numerischer Wert für die Lesbarkeit eines Textes. Je höher der Wert, umso leichter verständlich ist der Text. Entgegen anderer Anbieter für den FRE, welche mit der Formel für englische Sprache arbeiten,  nutzen wir von SEOfant ausnahmslos die offizielle Formel für die deutsche Sprache.</p><p class=\"hlp\">Entscheidend ist also die Frage: Welche Zielgruppe habe ich und wie komplex darf mein Text daher sein?</p>",
		
		h10: "<p class=\"hlp\">Die Wiener Sachtextformel dient zur Berechnung der Lesbarkeit deutschsprachiger Texte. Ein dargestellter Wert bis zu 4 steht demnach für sehr leichten Text, dagegen bezeichnet 15 einen sehr schwierigen Text.</p>",
		
		h11: "<p class=\"hlp\">So sieht die Seite als reine semantische Darstellung aus. Eine Suchmaschine orientiert sich anhand dieses Fundes und gewichtet Inhalte entsprechend. Eine korrekte und gute Semantik hilft einer Suchmaschine spürbar, die entsprechende Seite inhaltlich zu „verstehen“; und zu gewichten (bewerten).</p>",
		
		h12: "<p class=\"hlp\">Eine Vorschau Deiner Seite in Chats und „social networks“.</p>",
		
		h13: "<p class=\"hlp\">Geschlechtsneutrale Formulierungen sollten in Texten immer Berücksichtigung finden. SEOfant schaut, ob er Empfehlungen für Dich hat.</p>",
		
		h14: "<p class=\"hlp\">Mit Open Graph Tags, oder auch og-Tags genannt, hinterlegst Du Elemente im Quellcode bzw. markierst Elemente im Header. Das Markup wird dann für die Anzeige von Title, Description und Vorschaubild im Social Graph verwendet.</p>",
		
		h15: "<p class=\"hlp\">Ob man selbst nun Twitter nutzt oder nicht – irgendwer tut es. Und mit den korrekten technischen Hinweisen für Twitter sehen Verbreitungen dort deutlich professioneller aus.</p>",
		
		h16: "<p class=\"hlp\">Das Meta-Robots-Tag auf einer Website dient der Steuerung der Suchmaschinen-Crawler und befindet sich im &lt;head&gt;-Bereich der einzelnen Seiten.</p>",

		h17: "<p class=\"hlp\">LIX (Abkürzung aus dem Schwedischen <span lang=\"swe\">läsbarhetsindex</span>, „Lesbarkeitsindex“) ist ein weiterer Lesbarkeitsindex von Carl-Hugo Björnsson aus dem Jahre 1968.</p>"
	}
},

seofantsets = {
	showSettings: function($obj){
		$obj.html( seofantsets.collectSettings() ).fadeIn('normal', function(){
			seofant.clickHandler();
		});
	},
	
	collectSettings: function(){
		let output = '';
		
		output += "<div class=\"seofant_settings\"><h2 class=\"fst\">Einstellungen</h2>" + 
					"<p><span>API Schlüssel</span><textarea id=\"seofant_api_key\" name=\"seofant_api_key\"></textarea></p>" + 
					"<p class=\"seofant\"><a href=\"javascript:seofant.store();\">Speichern</a></p></div>";
		
		return output;
	},
	
	setSettings: function(){
		let $obj 	= jQuery('.seofant_settings'),
			aky		= $obj.find('#seofant_api_key').val().trim(),
			pl		= seofant.pickPermaLink();
		
		if(seofant.run == 0 && aky.length > 0){
			seofant.run = 1;
			
			$obj.html(seofant.waitS);
			
			data = {
				'action': 'SEOFANTsettings',
				'a': pl,
				'b': seofant.sec,
				'c': aky
			};
			
			jQuery.post(ajaxurl, data, function(c) {
				$obj.html(c);
				seofant.run = 0;
			});
		}
	}
};

jQuery(function(){
	seofant.init();
});